# Clear old room and stop script when no room in this area
execute unless block ~ ~ ~ pink_stained_glass at @n[type=marker,tag=fake_dungeon.map_generator.room_pastier] run fill ~ ~ ~ ~18 ~30 ~18 air
execute unless block ~ ~ ~ #fake_dungeon:rooms/rooms run return 0

# Reset rooms list
data modify storage fake_dungeon:map_generator possible_rooms.rooms set value []

# Set floor
data modify storage fake_dungeon:map_generator/room_info floor set value "floor_1"

# Set room type
function fake_dungeon:map_generator/find_room_type

# Set room ticket multiplier
function fake_dungeon:map_generator/find_room_tickets_multiplier

# Handle huge rooms
execute if data storage fake_dungeon:map_generator/room_info {type:"huge_room"} run return run function fake_dungeon:map_generator/huge_room_handling/handle_huge_room
execute if data storage fake_dungeon:map_generator/room_info {type:"huge_room_other_sides"} run return run function fake_dungeon:map_generator/huge_room_handling/handle_other_sides_of_huge_room

# Find all matching room shapes
function fake_dungeon:map_generator/determine_room_shape

# Find all matching rooms
function fake_dungeon:map_generator/find_matching_rooms

# Remove all rooms that had been used before (if not rooms left in room pool then allow for duplications of rooms)
function fake_dungeon:map_generator/reject_used_rooms

# Create error room if algorithm didn't find any rooms
execute unless data storage fake_dungeon:map_generator possible_rooms.rooms[] run return run function fake_dungeon:map_generator/create_error_room

# Choose one random room
function fake_dungeon:map_generator/draw_random_room
function fake_dungeon:map_generator/choose_one_room with storage fake_dungeon:map_generator possible_rooms

# Rotate room
function fake_dungeon:map_generator/rotate_room_to_fit_map

# Finally clone room
function fake_dungeon:map_generator/clone_room with storage fake_dungeon:map_generator possible_rooms.final_room_to_generate

# Do tasks like spawning markers etc.
function fake_dungeon:map_generator/do_room_specific_tasks

# Create doors to +x +z
function fake_dungeon:map_generator/generate_doors